/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.node;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.RSBlocks;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.util.StackListEntry;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNode;
import com.raoulvdberge.refinedstorage.tile.TileDetector;
import com.raoulvdberge.refinedstorage.tile.config.FilterConfig;
import com.raoulvdberge.refinedstorage.tile.config.FilterType;
import com.raoulvdberge.refinedstorage.tile.config.IRSFilterConfigProvider;
import com.raoulvdberge.refinedstorage.tile.config.RedstoneMode;
import com.raoulvdberge.refinedstorage.util.WorldUtils;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class NetworkNodeDetector
extends NetworkNode
implements IRSFilterConfigProvider {
    public static final String ID = "detector";
    private static final int SPEED = 5;
    public static final int MODE_UNDER = 0;
    public static final int MODE_EQUAL = 1;
    public static final int MODE_ABOVE = 2;
    private static final String NBT_MODE = "Mode";
    private static final String NBT_AMOUNT = "Amount";
    private final FilterConfig config = new FilterConfig.Builder(this).allowedFilterModeWhitelist().allowedFilterTypeItemsAndFluids().filterTypeItems().filterSizeOne().compareDamageAndNbt().customFilterTypeSupplier(ft -> this.world.field_72995_K ? FilterType.values()[TileDetector.TYPE.getValue()] : ft).build();
    private int mode = 1;
    private int amount = 0;
    private boolean powered = false;
    private boolean wasPowered;

    public NetworkNodeDetector(World world, BlockPos pos) {
        super(world, pos);
    }

    @Override
    public int getEnergyUsage() {
        return RS.INSTANCE.config.detectorUsage;
    }

    @Override
    public void updateNetworkNode() {
        super.updateNetworkNode();
        if (this.powered != this.wasPowered) {
            this.wasPowered = this.powered;
            this.world.func_175685_c(this.pos, (Block)RSBlocks.DETECTOR, true);
            WorldUtils.updateBlock(this.world, this.pos);
        }
        if (this.network != null && this.canUpdate() && this.ticks % 5 == 0) {
            if (this.config.isFilterTypeItem()) {
                StackListEntry<ItemStack> stack;
                ItemStack slot = this.config.getItemHandler().getStackInSlot(0);
                this.powered = !slot.func_190926_b() ? this.isPowered((stack = this.network.getItemStorageCache().getList().getEntry(slot, this.config.getCompare())) == null ? -1L : stack.getCount()) : this.isPowered(this.network.getItemStorageCache().getList().getStored());
            } else if (this.config.isFilterTypeFluid()) {
                StackListEntry<FluidStack> stack;
                FluidStack slot = this.config.getFluidHandler().getFluid(0);
                this.powered = slot != null ? this.isPowered((stack = this.network.getFluidStorageCache().getList().getEntry(slot, this.config.getCompare())) == null ? -1L : stack.getCount()) : this.isPowered(this.network.getFluidStorageCache().getList().getStored());
            }
        }
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public void onConnectedStateChange(INetwork network, boolean state) {
        super.onConnectedStateChange(network, state);
        if (!state) {
            this.powered = false;
        }
    }

    public boolean isPowered() {
        return this.powered;
    }

    public void setPowered(boolean powered) {
        this.powered = powered;
    }

    public boolean isPowered(long size) {
        if (size != -1L) {
            switch (this.mode) {
                case 0: {
                    return size < (long)this.amount;
                }
                case 2: {
                    return size > (long)this.amount;
                }
                case 1: {
                    return size == (long)this.amount;
                }
            }
            return false;
        }
        if (this.mode == 0 && this.amount != 0) {
            return true;
        }
        return this.mode == 1 && this.amount == 0;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    @Override
    public NBTTagCompound writeConfiguration(NBTTagCompound tag) {
        super.writeConfiguration(tag);
        tag.func_74768_a(NBT_MODE, this.mode);
        tag.func_74768_a(NBT_AMOUNT, this.amount);
        tag.func_74782_a("config", (NBTBase)this.config.writeToNBT(new NBTTagCompound()));
        return tag;
    }

    @Override
    public void readConfiguration(NBTTagCompound tag) {
        super.readConfiguration(tag);
        if (tag.func_74764_b(NBT_MODE)) {
            this.mode = tag.func_74762_e(NBT_MODE);
        }
        if (tag.func_74764_b(NBT_AMOUNT)) {
            this.amount = tag.func_74762_e(NBT_AMOUNT);
        }
        this.config.readFromNBT(tag.func_74775_l("config"));
    }

    @Override
    public void setRedstoneMode(RedstoneMode mode) {
    }

    @Override
    @Nonnull
    public FilterConfig getConfig() {
        return this.config;
    }
}

